<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;
    protected $fillable = array('name', 'rate', 'description', 'price', 'requirements', 'date', 'language_id', 'category_id', 'url');

    public function language()
    {
        return $this->belongsTo('App\Models\Language');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

}